unit IWCompCheckBoxWAP;

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,
  {$ENDIF}
  Classes, IWControlWAP, IWBaseWAPInterfaces, IWBaseControl, IWBaseRenderContext, IWWapTag,
  IWBaseComponent, IWBaseInterfaces, IWMarkupLanguageTag, IWTypes, IWBaseWapControl,
  IWWAPRenderContext;

type
  TIWCustomCheckBoxWAP = class(TIWCustomControlWAP, IIWInputControl)
  protected
    FChecked: Boolean;

    procedure SetValue(const AValue: string); virtual;
    procedure SetChecked(const AValue: Boolean);
    procedure InitControl; override;
  public
    function RenderWap(AContext: TIWBaseWapComponentContext): TIWWapTag; override;

    property Checked: Boolean read FChecked write SetChecked;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWCheckBoxWAP.bmp}
  TIWCheckBoxWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWCheckBoxWAP), 'TIWCheckBoxWAP.bmp')]
  {$ENDIF}
  TIWCheckBoxWAP = class(TIWCustomCheckBoxWAP)
  published
    property Caption;
    {$IFDEF VSNET}
    [Bindable(true)]
    {$ENDIF}    
    property Checked;
  end;


implementation

uses
  SWSystem, SysUtils, IWCompListBoxWAP;

{ TIWCustomCheckBoxWAP }

procedure TIWCustomCheckBoxWAP.InitControl;
begin
  inherited;
  Height := 21;
  Width := 121;
end;

function TIWCustomCheckBoxWAP.RenderWap(
  AContext: TIWBaseWapComponentContext): TIWWapTag;
begin
  if AContext.PageContext.OutputTagType = wotXHTMLMP then begin
    Result := TIWWAPTag.CreateTag('input');
    try
      Result.AddStringParam('type', 'checkbox');
      Result.AddStringParam('title', TextToXHTMLMP(Caption));
      Result.AddStringParam('name', Name);
      if Checked then begin
        Result.AddStringParam('checked', 'checked');
      end;
    except
      FreeAndNil(Result);
      raise;
    end;
  end else begin
    with TIWCustomListBoxWAP.Create(Self) do try
      Name := Self.Name;
      Items.Add(Self.Caption);
      RequireSelection := True;
      if FChecked then begin
        ItemIndex := 0;
      end;
      Result := RenderWML(AContext, sctCheckBox);
    finally
      Free;
    end;
  end;
  SetChecked(False);
end;

procedure TIWCustomCheckBoxWAP.SetChecked(const AValue: Boolean);
begin
  FChecked := AValue;
  Invalidate;
end;

procedure TIWCustomCheckBoxWAP.SetValue(const AValue: string);
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  FChecked := AnsiSameText(AValue, 'checked') or AnsiSameText(AValue, '0') or
    AnsiSameText(AValue, 'on');
  Invalidate;
end;

end.
